#!/usr/bin/env python
# Set Script Shortcuts

# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050827 - first draft of this program
# 060202 - Alex - rewritten to modify Menu.ScriptMenu directly
# 072008 - Alex - some functionality moved to Menu.py

# ---------------------------------------

# Specify the shortcuts here
# Valid modifiers are CTRL, ALT, and SHIFT
#   (on MacOS, wx replaces CTRL with command and ALT with option)

shortcuts = {
    "Print Report": "CTRL-P",
    "Select ID": "CTRL-2",
    "Add Checklist Item to Task": "CTRL-3",
    "Sort By Priority": "CTRL-4",
    "Sort By Selected Column": "CTRL-5",
    "Save Backup Copy of Database": "CTRL-B",
    }

# ---------------------------------------

def SetScriptShortcuts(list):  # deprecated in v0.10
    for i, item in enumerate(list):
        if i == 0:
            continue
        if len(item) > 1:
            SetScriptShortcuts(item)
        else:
            name = item[0]
            if name in shortcuts:
                list[i][0] = name + "\t" + shortcuts[name]

def Do():
    Data.Option['Shortcuts'] = shortcuts
    SetScriptShortcuts(Menu.ScriptMenu)
    Menu.RefreshScriptMenu()

Do()
